
# $+HEADER$
#
# Copyright 2017-2018 Christoph Lueders
#
# This file is part of the PtCut project: <http://wrogn.com/ptcut>
#
# PtCut is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# PtCut is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with PtCut.  If not, see <http://www.gnu.org/licenses/>.
#
# $-HEADER$

inf = float("inf")

def read_grid(f, what=0, transpose=False):
   val = {}
   for line in f:
      if line.startswith("Grid point:"):
         # Grid point: k18 = 5.0, k19 = 200.0
         a = line.split(":")
         a = a[1].split(",")
         if transpose:
            a[0], a[1] = a[1], a[0]
         idx = tuple([float(t.split("=")[1]) for t in a])
      elif line.startswith("Solutions: "):
         # Solutions: 1, dim=0.0, hs=3.0, vs=1.0
         if what in (0,1):
            a = line.split(":")
            a = a[1].split(",")
            val[idx] = (a[1].split("=")[1] if what == 1 else a[0]).strip()
      elif line.startswith("Connected components: "):
         # Connected components: 1
         if what == 2:
            a = line.split(":")
            val[idx] = a[1].strip()
      elif line.startswith("Graph ID: "):
         # Graph ID: 4C6A8ZTWXMA9
         if what == 3:
            a = line.split(":")
            val[idx] = a[1].strip()[:6]
      elif line.strip() == "There is no solution!":
         val[idx] = "-1" if what == 1 else "0"
   return val


def print_grid(g):
   l = len(next(iter(g.keys())))
   idx = [set() for _ in range(l)]
   for k in g.keys():
      for i,v in enumerate(k):
         idx[i].add(v)

   assert l == 2

   print(end="         ")
   for i in sorted(idx[0]):
      print(end="{:7g}".format(i))
   print()
   for j in sorted(idx[1], reverse=True):
      print(end="{:7g}  ".format(j))
      for i in sorted(idx[0]):
         try:
            print(end="{:>7s}".format(g[(i,j)]))
         except KeyError:
            print(end="      ")
      print()


if __name__ == "__main__":
   import sys

   what = 0
   transpose = False
   tex = False
   for i in sys.argv[1:]:
      if i == "-d":
         what = 1
      elif i == "-c":
         what = 2
      elif i == "-g":
         what = 3
      elif i == "-t":
         transpose = True
      elif i == "-x":
         tex = 1
      elif i == "-xl":
         tex = 2
      elif i[0] != "-":
         fname = i

   with open(fname) as f:
      g = read_grid(f, what, transpose=transpose)
      if tex == 1:
         print("x y meta")
         for x,y in sorted(g.items()):
            print("{} {} {}".format(x[0], x[1], y))
      elif tex == 2:
         print("x y meta")
         for x,y in sorted(g.items()):
            print("{} {} {}".format(x[0], x[1], chr(65+32+int(y))))
      else:
         print_grid(g)
