
# $+HEADER$
# 
# Copyright 2017-2018 Christoph Lueders
# 
# This file is part of the PTCUT project: <http://wrogn.com/ptcut>
# 
# PTCUT is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or 
# (at your option) any later version.
# 
# PTCUT is distributed in the hope that it will be useful, 
# but WITHOUT ANY WARRANTY; without even the implied warranty of 
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
# GNU Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public License
# along with PTCUT.  If not, see <http://www.gnu.org/licenses/>.
# 
# $-HEADER$

svnrev = int("$Rev: 6627 $".split()[1])
comp = {}
speedups = []

def geoavg(l):
   p = 1
   for i in l:
      p *= i
   return p ** (1.0 / len(l))


def printit(prt, d):
   if d["model"]:
      speedup = " " * 6
      global comp
      if d["model"] in comp and comp[d["model"]] >= 0.001 and d["solutions"] > 0:
         fact = comp[d["model"]] / d["time"] if d["time"] > 0 else 0
         speedup = "{:6.2f}".format(fact)
         global speedups
         speedups.append(fact)
      if prt:
         print("{:<26s} {:3d}  {:3d}  {:3d} {:8.3f}  {}  {:8}  {}".format(d["model"], d["dim"], d["formulae"], d["solutions"], d["time"], speedup, "." if d["verified"] == -1 else "ok" if d["verified"] else "MISMATCH", d["combos"]))
      if not d["model"] in comp:
         comp[d["model"]] = d["time"]

def filter_speeds(f, prt):
   header = False
   d = {}
   d["model"] = None
   for line in f:
      if line.startswith("Solving "):
         printit(prt, d)
         arr = line.split()
         if not header:
            header = True
            if prt:
               print("Parameters: {}".format(" ".join(arr[3:])))
         d["model"] = arr[1]
         d["combos"] = -1
         d["dim"] = -1
         d["formulae"] = -1
         d["solutions"] = -1
         d["time"] = -1
         d["verified"] = -1
      elif line.startswith("Worst case combinations:"):
         # Worst case combinations: 2 * 2 * 2 * 2 * 3 * 3 * 3 * 3 * 3 * 3 * 4 * 4 * 12  = 2,239,488
         arr = line.split("=")
         d["combos"] = int(arr[1].replace(",",""))
      elif line.startswith("Dimension:"):
         # Dimension: 12
         arr = line.split()
         d["dim"] = int(arr[1])
      elif line.startswith("Formulae:"):
         # Formulae: 12
         arr = line.split()
         d["formulae"] = int(arr[1])
      elif line.startswith("Solutions: "):
         # Solutions: 1, dim=0.0, hs=3.0, vs=1.0
         arr = line.split()
         d["solutions"] = int(arr[1][:-1])
      elif line.strip() == "There is no solution!":
         d["solutions"] = 0
      elif line.startswith("Intersection time:"):
         # Intersection time: 29.006163 sec, total intersections: 2,429, total inclusion tests: 22,259
         arr = line.split()
         d["time"] = float(arr[2])
      elif line.startswith("Solutions "):
         # Solutions match Satya's solutions
         d["verified"] = int(line.strip() == "Solutions match Satya's solutions")
   printit(prt, d)


if __name__ == "__main__":
   import sys

   if len(sys.argv) < 2:
      print(
"""
usage: 1. showtime <log-file>
       2. showtime <base-log-file> <new-log-file>

1.: Show time, dimension, number of formulae and number of prevarieties of
calculations in <log-file>.

2.: Show same information as in 1. for <new-log-file> and use data from
<base-log-file> as base for comparison.""")
      sys.exit(1)

   with open(sys.argv[1]) as f:
      filter_speeds(f, len(sys.argv) <= 2)

   if len(sys.argv) > 2:
      print()
      with open(sys.argv[2]) as f:
         filter_speeds(f, True)
      #avg = len(speedups) / sum([1 / i for i in speedups])
      avg = geoavg(speedups)
      print("avg speedup: {:.2f}".format(avg))
