// $+HEADER$
// 
// Copyright 2015 Christoph Lueders
// 
// This file is part of the BIGNUM Library.
// 
// The BIGNUM Library is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or (at your 
// option) any later version.
// 
// The BIGNUM Library is distributed in the hope that it will be useful, but 
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
// or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public 
// License for more details.
// 
// You should have received a copy of the GNU Lesser General Public License
// along with the BIGNUM Library.  If not, see <http://www.gnu.org/licenses/>.
// 
// $-HEADER$

// $Date: 2015-04-24 11:28:16 +0200 (Fr, 24 Apr 2015) $
// $Rev: 26590 $

// $dissect$ support.txt
#include "cl/str_conv.h"
#include "dkss.h"

using namespace cl;
using namespace std;

namespace bignum {

// $dissect$ ringdata.txt
static const ring_data rings[] = {
   // factor, pow_2, bit_length, generator
   { 1, 1, 2, 2 },
   { 1, 2, 3, 2 },
   { 3, 2, 4, 2 },
   { 1, 4, 5, 3 },
   { 5, 3, 6, 6 },
   { 3, 5, 7, 5 },
   { 3, 6, 8, 5 },
   { 1, 8, 9, 3 },
   { 3, 8, 10, 11 },
   { 9, 7, 11, 5 },
   { 13, 8, 12, 3 },
   { 15, 9, 13, 17 },
   { 3, 12, 14, 11 },
   { 9, 11, 15, 5 },
   { 5, 13, 16, 3 },
   { 1, 16, 17, 3 },
   { 5, 15, 18, 3 },
   { 33, 13, 19, 10 },
   { 3, 18, 20, 10 },
   { 9, 17, 21, 19 },
   { 21, 17, 22, 20 },
   { 7, 20, 23, 3 },
   { 13, 20, 24, 15 },
   { 11, 21, 25, 3 },
   { 69, 19, 26, 7 },
   { 25, 22, 27, 3 },
   { 5, 25, 28, 3 },
   { 7, 26, 29, 3 },
   { 45, 24, 30, 11 },
   { 15, 27, 31, 31 },
   { 3, 30, 32, 5 },
   { 59, 27, 33, 3 },
   { 23, 29, 34, 5 },
   { 45, 29, 35, 7 },
   { 49, 30, 36, 3 },
   { 9, 33, 37, 7 },
   { 3, 36, 38, 22 },
   { 73, 32, 39, 3 },
   { 99, 33, 40, 13 },
   { 15, 37, 41, 7 },
   { 5, 39, 42, 3 },
   { 3, 41, 43, 5 },
   { 63, 38, 44, 5 },
   { 27, 40, 45, 5 },
   { 9, 42, 46, 5 },
   { 9, 43, 47, 5 },
   { 15, 44, 48, 7 },
   { 27, 44, 49, 5 },
   { 63, 44, 50, 11 },
   { 19, 46, 51, 3 },
   { 15, 48, 52, 19 },
   { 7, 50, 53, 6 },
   { 23, 49, 54, 3 },
   { 7, 52, 55, 3 },
   { 17, 51, 56, 3 },
   { 25, 52, 57, 3 },
   { 5, 55, 58, 6 },
   { 51, 53, 59, 5 },
   { 49, 54, 60, 5 },
   { 27, 56, 61, 5 },
   { 29, 57, 62, 3 },
   { 87, 56, 63, 5 },
   { 27, 59, 64, 5 },
   { 31, 60, 65, 3 },
   { 45, 60, 66, 11 },
   { 9, 63, 67, 11 },
   { 3, 66, 68, 10 },
   { 9, 65, 69, 19 },
   { 75, 63, 70, 22 },
   { 9, 67, 71, 7 },
   { 33, 66, 72, 7 },
   { 31, 68, 73, 3 },
   { 23, 69, 74, 3 },
   { 221, 67, 75, 3 },
   { 39, 70, 76, 11 },
   { 39, 71, 77, 7 },
   { 5, 75, 78, 3 },
   { 39, 73, 79, 17 },
   { 29, 75, 80, 3 },
   { 67, 74, 81, 3 },
   { 15, 78, 82, 11 },
   { 25, 78, 83, 3 },
   { 145, 76, 84, 3 },
   { 9, 81, 85, 13 },
   { 13, 82, 86, 3 },
   { 249, 79, 87, 5 },
   { 5, 85, 88, 3 },
   { 51, 83, 89, 11 },
   { 37, 84, 90, 3 },
   { 53, 85, 91, 3 },
   { 65, 85, 92, 3 },
   { 87, 86, 93, 7 },
   { 61, 88, 94, 3 },
   { 7, 92, 95, 3 },
   { 57, 90, 96, 23 },
   { 27, 92, 97, 5 },
   { 29, 93, 98, 3 },
   { 33, 93, 99, 7 },
   { 43, 94, 100, 3 },
   { 85, 94, 101, 3 },
   { 57, 96, 102, 10 },
   { 121, 96, 103, 3 },
   { 43, 98, 104, 3 },
   { 131, 97, 105, 3 },
   { 315, 97, 106, 19 },
   { 219, 99, 107, 7 },
   { 29, 103, 108, 3 },
   { 67, 102, 109, 3 },
   { 43, 104, 110, 3 },
   { 53, 105, 111, 3 },
   { 37, 106, 112, 3 },
   { 231, 105, 113, 15 },
   { 105, 107, 114, 11 },
   { 93, 108, 115, 7 },
   { 15, 112, 116, 11 },
   { 73, 110, 117, 3 },
   { 95, 111, 118, 6 },
   { 129, 111, 119, 5 },
   { 153, 112, 120, 7 },
   { 115, 114, 121, 3 },
   { 163, 114, 122, 3 },
   { 7, 120, 123, 3 },
   { 33, 118, 124, 5 },
   { 51, 119, 125, 11 },
   { 71, 119, 126, 3 },
   { 177, 119, 127, 10 },
   { 81, 121, 128, 5 },
   { 11, 125, 129, 3 },
   { 5, 127, 130, 17 },
   { 11, 127, 131, 3 },
   { 81, 125, 132, 5 },
   { 21, 128, 133, 5 },
   { 21, 129, 134, 5 },
   { 111, 128, 135, 10 },
   { 65, 129, 136, 6 },
   { 295, 128, 137, 3 },
   { 9, 134, 138, 5 },
   { 53, 133, 139, 3 },
   { 247, 132, 140, 5 },
   { 67, 134, 141, 3 },
   { 147, 134, 142, 19 },
   { 225, 135, 143, 11 },
   { 111, 137, 144, 11 },
   { 31, 140, 145, 5 },
   { 219, 138, 146, 5 },
   { 355, 138, 147, 3 },
   { 29, 143, 148, 3 },
   { 141, 141, 149, 15 },
   { 43, 144, 150, 3 },
   { 249, 143, 151, 5 },
   { 17, 147, 152, 3 },
   { 35, 147, 153, 3 },
   { 175, 146, 154, 3 },
   { 81, 148, 155, 5 },
   { 163, 148, 156, 3 },
   { 191, 149, 157, 3 },
   { 65, 151, 158, 7 },
   { 63, 153, 159, 5 },
   { 315, 151, 160, 13 },
   { 131, 153, 161, 3 },
   { 105, 155, 162, 11 },
   { 117, 156, 163, 5 },
   { 43, 158, 164, 3 },
   { 183, 157, 165, 5 },
   { 9, 162, 166, 5 },
   { 225, 159, 167, 13 },
   { 141, 160, 168, 5 },
   { 99, 162, 169, 5 },
   { 75, 163, 170, 13 },
   { 93, 164, 171, 17 },
   { 15, 168, 172, 33 },
   { 131, 165, 173, 3 },
   { 61, 168, 174, 3 },
   { 91, 168, 175, 3 },
   { 165, 168, 176, 28 },
   { 7, 174, 177, 3 },
   { 177, 170, 178, 11 },
   { 207, 171, 179, 10 },
   { 27, 175, 180, 5 },
   { 51, 175, 181, 7 },
   { 95, 175, 182, 3 },
   { 7, 180, 183, 3 },
   { 347, 175, 184, 3 },
   { 333, 176, 185, 7 },
   { 299, 177, 186, 3 },
   { 127, 180, 187, 3 },
   { 83, 181, 188, 3 },
   { 25, 184, 189, 3 },
   { 29, 185, 190, 3 },
   { 3, 189, 191, 10 },
   { 13, 188, 192, 3 },
   { 7, 190, 193, 3 },
   { 187, 186, 194, 3 },
   { 45, 189, 195, 26 },
   { 57, 190, 196, 7 },
   { 617, 187, 197, 3 },
   { 159, 190, 198, 5 },
   { 149, 191, 199, 3 },
   { 111, 193, 200, 5 },
   { 183, 193, 201, 5 },
   { 163, 194, 202, 3 },
   { 3, 201, 203, 5 },
   { 261, 195, 204, 14 },
   { 203, 197, 205, 3 },
   { 45, 200, 206, 7 },
   { 85, 200, 207, 3 },
   { 181, 200, 208, 3 },
   { 191, 201, 209, 3 },
   { 9, 206, 210, 10 },
   { 3, 209, 211, 7 },
   { 65, 205, 212, 3 },
   { 11, 209, 213, 3 },
   { 21, 209, 214, 10 },
   { 9, 211, 215, 5 },
   { 275, 207, 216, 3 },
   { 261, 208, 217, 7 },
   { 99, 211, 218, 5 },
   { 73, 212, 219, 3 },
   { 27, 215, 220, 5 },
   { 31, 216, 221, 3 },
   { 105, 215, 222, 17 },
   { 505, 214, 223, 3 },
   { 183, 216, 224, 17 },
   { 615, 215, 225, 17 },
   { 55, 220, 226, 3 },
   { 279, 218, 227, 5 },
   { 381, 219, 228, 11 },
   { 75, 222, 229, 7 },
   { 395, 221, 230, 3 },
   { 245, 223, 231, 3 },
   { 351, 223, 232, 7 },
   { 15, 229, 233, 7 },
   { 63, 228, 234, 17 },
   { 115, 228, 235, 3 },
   { 29, 231, 236, 3 },
   { 25, 232, 237, 3 },
   { 195, 230, 238, 38 },
   { 207, 231, 239, 5 },
   { 83, 233, 240, 3 },
   { 285, 232, 241, 13 },
   { 37, 236, 242, 3 },
   { 67, 236, 243, 3 },
   { 95, 237, 244, 3 },
   { 67, 238, 245, 3 },
   { 65, 239, 246, 3 },
   { 533, 237, 247, 3 },
   { 17, 243, 248, 3 },
   { 291, 240, 249, 5 },
   { 29, 245, 250, 3 },
   { 35, 245, 251, 3 },
   { 177, 244, 252, 5 },
   { 203, 245, 253, 5 },
   { 75, 247, 254, 37 },
   { 167, 247, 255, 3 },
   { 207, 248, 256, 5 },
   { 39, 251, 257, 5 },
   { 43, 252, 258, 3 },
   { 313, 250, 259, 3 },
   { 37, 254, 260, 3 },
   { 135, 253, 261, 13 },
   { 633, 252, 262, 17 },
   { 51, 257, 263, 11 },
   { 65, 257, 264, 6 },
   { 239, 257, 265, 3 },
   { 147, 258, 266, 17 },
   { 91, 260, 267, 3 },
   { 55, 262, 268, 3 },
   { 51, 263, 269, 13 },
   { 159, 262, 270, 10 },
   { 121, 264, 271, 3 },
   { 17, 267, 272, 5 },
   { 25, 268, 273, 3 },
   { 81, 267, 274, 7 },
   { 123, 268, 275, 11 },
   { 175, 268, 276, 6 },
   { 99, 270, 277, 5 },
   { 3, 276, 278, 19 },
   { 177, 271, 279, 15 },
   { 27, 275, 280, 5 },
   { 21, 276, 281, 5 },
   { 261, 273, 282, 5 },
   { 147, 275, 283, 10 },
   { 81, 277, 284, 5 },
   { 297, 276, 285, 10 },
   { 63, 280, 286, 13 },
   { 231, 279, 287, 17 },
   { 125, 281, 288, 3 },
   { 357, 280, 289, 10 },
   { 135, 282, 290, 11 },
   { 325, 282, 291, 6 },
   { 37, 286, 292, 3 },
   { 7, 290, 293, 3 },
   { 77, 287, 294, 3 },
   { 33, 289, 295, 10 },
   { 37, 290, 296, 3 },
   { 59, 291, 297, 3 },
   { 107, 291, 298, 3 },
   { 141, 291, 299, 13 },
   { 287, 291, 300, 3 },
   { 15, 297, 301, 13 },
   { 177, 294, 302, 11 },
   { 81, 296, 303, 5 },
   { 207, 296, 304, 5 },
   { 93, 298, 305, 5 },
   { 71, 299, 306, 3 },
   { 177, 299, 307, 11 },
   { 389, 299, 308, 3 },
   { 267, 300, 309, 5 },
   { 107, 303, 310, 3 },
   { 141, 303, 311, 11 },
   { 13, 308, 312, 3 },
   { 239, 305, 313, 3 },
   { 65, 307, 314, 3 },
   { 231, 307, 315, 29 },
   { 285, 307, 316, 23 },
   { 957, 307, 317, 5 },
   { 21, 313, 318, 5 },
   { 75, 312, 319, 13 },
   { 13, 316, 320, 3 },
   { 153, 313, 321, 5 },
   { 207, 314, 322, 7 },
   { 7, 320, 323, 5 },
   { 559, 314, 324, 3 },
   { 109, 318, 325, 3 },
   { 99, 319, 326, 5 },
   { 51, 321, 327, 7 },
   { 177, 320, 328, 5 },
   { 457, 320, 329, 3 },
   { 625, 320, 330, 3 },
   { 81, 324, 331, 5 },
   { 63, 326, 332, 5 },
   { 35, 327, 333, 3 },
   { 561, 324, 334, 5 },
   { 469, 326, 335, 5 },
   { 297, 327, 336, 5 },
   { 261, 328, 337, 5 },
   { 125, 331, 338, 3 },
   { 45, 333, 339, 38 },
   { 63, 334, 340, 10 },
   { 143, 333, 341, 3 },
   { 177, 334, 342, 7 },
   { 15, 339, 343, 19 },
   { 133, 336, 344, 3 },
   { 25, 340, 345, 6 },
   { 23, 341, 346, 3 },
   { 159, 339, 347, 5 },
   { 559, 338, 348, 3 },
   { 67, 342, 349, 3 },
   { 55, 344, 350, 3 },
   { 81, 344, 351, 5 },
   { 17, 347, 352, 3 },
   { 301, 344, 353, 3 },
   { 423, 345, 354, 5 },
   { 3, 353, 355, 5 },
   { 201, 348, 356, 5 },
   { 941, 347, 357, 3 },
   { 65, 351, 358, 3 },
   { 161, 351, 359, 6 },
   { 165, 352, 360, 13 },
   { 35, 355, 361, 3 },
   { 55, 356, 362, 3 },
   { 231, 355, 363, 13 },
   { 253, 356, 364, 3 },
   { 265, 356, 365, 3 },
   { 261, 357, 366, 5 },
   { 189, 359, 367, 5 },
   { 281, 359, 368, 3 },
   { 131, 361, 369, 3 },
   { 9, 366, 370, 7 },
   { 19, 366, 371, 3 },
   { 113, 365, 372, 3 },
   { 195, 365, 373, 23 },
   { 993, 364, 374, 14 },
   { 555, 365, 375, 11 },
   { 39, 370, 376, 5 },
   { 171, 369, 377, 10 },
   { 45, 372, 378, 13 },
   { 197, 371, 379, 6 },
   { 83, 373, 380, 3 },
   { 39, 375, 381, 5 },
   { 195, 374, 382, 17 },
   { 725, 373, 383, 3 },
   { 285, 375, 384, 13 },
   { 41, 379, 385, 3 },
   { 23, 381, 386, 3 },
   { 159, 379, 387, 10 },
   { 211, 380, 388, 3 },
   { 67, 382, 389, 3 },
   { 235, 382, 390, 3 },
   { 735, 381, 391, 17 },
   { 485, 383, 392, 3 },
   { 7, 390, 393, 3 },
   { 23, 389, 394, 3 },
   { 39, 389, 395, 7 },
   { 29, 391, 396, 3 },
   { 183, 389, 397, 5 },
   { 55, 392, 398, 6 },
   { 105, 392, 399, 29 },
   { 347, 391, 400, 3 },
   { 143, 393, 401, 3 },
   { 21, 397, 402, 10 },
   { 81, 396, 403, 5 },
   { 57, 398, 404, 11 },
   { 93, 398, 405, 15 },
   { 1095, 395, 406, 7 },
   { 97, 400, 407, 3 },
   { 613, 398, 408, 3 },
   { 585, 399, 409, 11 },
   { 3, 408, 410, 11 },
   { 465, 402, 411, 23 },
   { 27, 407, 412, 5 },
   { 39, 407, 413, 5 },
   { 169, 406, 414, 3 },
   { 861, 405, 415, 5 },
   { 63, 410, 416, 15 },
   { 99, 410, 417, 5 },
   { 33, 412, 418, 19 },
   { 403, 410, 419, 3 },
   { 105, 413, 420, 13 },
   { 31, 416, 421, 3 },
   { 129, 414, 422, 5 },
   { 327, 414, 423, 7 },
   { 71, 417, 424, 3 },
   { 291, 416, 425, 7 },
   { 877, 416, 426, 3 },
   { 179, 419, 427, 3 },
   { 81, 421, 428, 19 },
   { 1059, 418, 429, 10 },
   { 393, 421, 430, 5 },
   { 933, 421, 431, 5 },
   { 843, 422, 432, 5 },
   { 765, 423, 433, 7 },
   { 565, 424, 434, 3 },
   { 7, 432, 435, 3 },
   { 1505, 425, 436, 3 },
   { 75, 430, 437, 19 },
   { 225, 430, 438, 7 },
   { 953, 429, 439, 3 },
   { 3, 438, 440, 5 },
   { 105, 434, 441, 13 },
   { 193, 434, 442, 3 },
   { 81, 436, 443, 5 },
   { 745, 434, 444, 3 },
   { 155, 437, 445, 3 },
   { 419, 437, 446, 3 },
   { 177, 439, 447, 7 },
   { 223, 440, 448, 3 },
   { 45, 443, 449, 21 },
   { 177, 442, 450, 14 },
   { 683, 441, 451, 3 },
   { 261, 443, 452, 11 },
   { 25, 448, 453, 3 },
   { 81, 447, 454, 14 },
   { 155, 447, 455, 3 },
   { 955, 446, 456, 6 },
   { 333, 448, 457, 11 },
   { 1181, 447, 458, 3 },
   { 33, 453, 459, 5 },
   { 27, 455, 460, 5 },
   { 67, 454, 461, 3 },
   { 57, 456, 462, 5 },
   { 115, 456, 463, 6 },
   { 449, 455, 464, 3 },
   { 611, 455, 465, 3 },
   { 585, 456, 466, 7 },
   { 135, 459, 467, 7 },
   { 669, 458, 468, 5 },
   { 313, 460, 469, 3 },
   { 45, 464, 470, 7 },
   { 539, 461, 471, 3 },
   { 183, 464, 472, 7 },
   { 131, 465, 473, 3 },
   { 323, 465, 474, 3 },
   { 137, 467, 475, 3 },
   { 17, 471, 476, 3 },
   { 67, 470, 477, 3 },
   { 293, 469, 478, 3 },
   { 551, 469, 479, 3 },
   { 595, 470, 480, 3 },
   { 445, 472, 481, 3 },
   { 249, 474, 482, 5 },
   { 123, 476, 483, 7 },
   { 459, 475, 484, 5 },
   { 447, 476, 485, 5 },
   { 65, 479, 486, 3 },
   { 819, 477, 487, 29 },
   { 261, 479, 488, 13 },
   { 115, 482, 489, 6 },
   { 77, 483, 490, 3 },
   { 53, 485, 491, 3 },
   { 181, 484, 492, 3 },
   { 669, 483, 493, 5 },
   { 253, 486, 494, 3 },
   { 283, 486, 495, 3 },
   { 141, 488, 496, 5 },
   { 105, 490, 497, 23 },
   { 125, 491, 498, 6 },
   { 873, 489, 499, 5 },
   { 1101, 489, 500, 19 },
   { 239, 493, 501, 3 },
   { 299, 493, 502, 3 },
   { 433, 494, 503, 3 },
   { 1451, 493, 504, 3 },
   { 185, 497, 505, 3 },
   { 625, 496, 506, 3 },
   { 295, 498, 507, 3 },
   { 57, 502, 508, 14 },
   { 629, 499, 509, 3 },
   { 711, 500, 510, 7 },
   { 127, 504, 511, 3 },
   { 2401, 500, 512, 3 },
   { 519, 503, 513, 10 },
   { 745, 504, 514, 3 },
   { 755, 505, 515, 3 },
   { 113, 509, 516, 3 },
   { 267, 508, 517, 10 },
   { 249, 510, 518, 5 },
   { 783, 509, 519, 10 },
   { 101, 513, 520, 3 },
   { 15, 517, 521, 14 },
   { 69, 515, 522, 5 },
   { 921, 513, 523, 5 },
   { 39, 518, 524, 5 },
   { 87, 518, 525, 7 },
   { 15, 522, 526, 23 },
   { 417, 518, 527, 7 },
   { 371, 519, 528, 3 },
   { 233, 521, 529, 3 },
   { 169, 522, 530, 3 },
   { 33, 525, 531, 7 },
   { 823, 522, 532, 3 },
   { 367, 524, 533, 3 },
   { 189, 526, 534, 5 },
   { 873, 525, 535, 5 },
   { 3, 534, 536, 5 },
   { 131, 529, 537, 3 },
   { 813, 528, 538, 13 },
   { 277, 530, 539, 3 },
   { 95, 533, 540, 3 },
   { 959, 531, 541, 3 },
   { 169, 534, 542, 3 },
   { 141, 535, 543, 7 },
   { 163, 536, 544, 3 },
   { 79, 538, 545, 3 },
   { 81, 539, 546, 7 },
   { 385, 538, 547, 3 },
   { 193, 540, 548, 3 },
   { 465, 540, 549, 13 },
   { 1229, 539, 550, 3 },
   { 545, 541, 551, 3 },
   { 151, 544, 552, 3 },
   { 255, 545, 553, 7 },
   { 1457, 543, 554, 3 },
   { 225, 547, 555, 7 },
   { 435, 547, 556, 7 },
   { 677, 547, 557, 3 },
   { 637, 548, 558, 5 },
   { 25, 554, 559, 6 },
   { 65, 553, 560, 6 },
   { 645, 551, 561, 7 },
   { 441, 553, 562, 15 },
   { 141, 555, 563, 17 },
   { 141, 556, 564, 5 },
   { 127, 558, 565, 3 },
   { 77, 559, 566, 5 },
   { 393, 558, 567, 13 },
   { 151, 560, 568, 3 },
   { 363, 560, 569, 23 },
   { 145, 562, 570, 3 },
   { 319, 562, 571, 3 },
   { 507, 563, 572, 5 },
   { 731, 563, 573, 3 },
   { 107, 567, 574, 3 },
   { 741, 565, 575, 5 },
   { 285, 567, 576, 65 },
   { 361, 568, 577, 3 },
   { 345, 569, 578, 17 },
   { 337, 570, 579, 3 },
   { 627, 570, 580, 13 },
   { 705, 571, 581, 13 },
   { 765, 572, 582, 19 },
   { 171, 575, 583, 7 },
   { 81, 577, 584, 5 },
   { 327, 576, 585, 10 },
   { 1061, 575, 586, 3 },
   { 319, 578, 587, 3 },
   { 125, 581, 588, 3 },
   { 47, 583, 589, 3 },
   { 363, 581, 590, 10 },
   { 427, 582, 591, 3 },
   { 567, 582, 592, 13 },
   { 215, 585, 593, 3 },
   { 531, 584, 594, 10 },
   { 519, 585, 595, 11 },
   { 89, 589, 596, 3 },
   { 161, 589, 597, 3 },
   { 555, 588, 598, 7 },
   { 81, 592, 599, 5 },
   { 49, 594, 600, 3 },
   { 233, 593, 601, 3 },
   { 961, 592, 602, 3 },
   { 245, 595, 603, 3 },
   { 183, 596, 604, 7 },
   { 67, 598, 605, 3 },
   { 955, 596, 606, 3 },
   { 659, 597, 607, 3 },
   { 133, 600, 608, 3 },
   { 87, 602, 609, 7 },
   { 1469, 599, 610, 5 },
   { 319, 602, 611, 3 },
   { 207, 604, 612, 5 },
   { 701, 603, 613, 3 },
   { 263, 605, 614, 3 },
   { 581, 605, 615, 3 },
   { 347, 607, 616, 3 },
   { 189, 609, 617, 11 },
   { 305, 609, 618, 3 },
   { 7, 616, 619, 3 },
   { 275, 611, 620, 3 },
   { 267, 612, 621, 5 },
   { 655, 612, 622, 7 },
   { 103, 616, 623, 3 },
   { 401, 615, 624, 3 },
   { 265, 616, 625, 3 },
   { 783, 616, 626, 7 },
   { 611, 617, 627, 5 },
   { 95, 621, 628, 3 },
   { 103, 622, 629, 3 },
   { 345, 621, 630, 14 },
   { 85, 624, 631, 3 },
   { 63, 626, 632, 5 },
   { 231, 625, 633, 10 },
   { 345, 625, 634, 11 },
   { 621, 625, 635, 5 },
   { 449, 627, 636, 3 },
   { 947, 627, 637, 3 },
   { 99, 631, 638, 7 },
   { 725, 629, 639, 3 },
   { 101, 633, 640, 3 },
   { 179, 633, 641, 3 },
   { 865, 632, 642, 3 },
   { 621, 633, 643, 5 },
   { 145, 636, 644, 7 },
   { 203, 637, 645, 3 },
   { 955, 636, 646, 13 },
   { 405, 638, 647, 22 },
   { 141, 640, 648, 7 },
   { 221, 641, 649, 3 },
   { 117, 643, 650, 10 },
   { 1063, 640, 651, 3 },
   { 619, 642, 652, 3 },
   { 1065, 642, 653, 19 },
   { 23, 649, 654, 3 },
   { 237, 647, 655, 19 },
   { 275, 647, 656, 3 },
   { 155, 649, 657, 3 },
   { 15, 654, 658, 22 },
   { 97, 652, 659, 3 },
   { 1029, 649, 660, 26 },
   { 471, 652, 661, 5 },
   { 77, 655, 662, 3 },
   { 735, 653, 663, 11 },
   { 387, 655, 664, 5 },
   { 183, 657, 665, 5 },
   { 1247, 655, 666, 5 },
   { 9, 663, 667, 7 },
   { 95, 661, 668, 12 },
   { 25, 664, 669, 3 },
   { 667, 660, 670, 5 },
   { 357, 662, 671, 11 },
   { 495, 663, 672, 7 },
   { 179, 665, 673, 3 },
   { 77, 667, 674, 3 },
   { 375, 666, 675, 7 },
   { 525, 666, 676, 17 },
   { 747, 667, 677, 5 },
   { 393, 669, 678, 5 },
   { 1953, 668, 679, 11 },
   { 113, 673, 680, 3 },
   { 515, 671, 681, 3 },
   { 75, 675, 682, 14 },
   { 111, 676, 683, 5 },
   { 165, 676, 684, 29 },
   { 155, 677, 685, 6 },
   { 255, 678, 686, 11 },
   { 423, 678, 687, 5 },
   { 347, 679, 688, 3 },
   { 381, 680, 689, 5 },
   { 567, 680, 690, 5 },
   { 1171, 680, 691, 3 },
   { 1235, 681, 692, 3 },
   { 93, 686, 693, 5 },
   { 633, 684, 694, 17 },
   { 357, 686, 695, 29 },
   { 1311, 685, 696, 15 },
   { 617, 687, 697, 3 },
   { 159, 690, 698, 7 },
   { 63, 693, 699, 15 },
   { 595, 690, 700, 3 },
   { 51, 695, 701, 13 },
   { 1601, 691, 702, 3 },
   { 91, 696, 703, 3 },
   { 381, 695, 704, 14 },
   { 231, 697, 705, 13 },
   { 607, 696, 706, 3 },
   { 1555, 696, 707, 21 },
   { 223, 700, 708, 3 },
   { 447, 700, 709, 10 },
   { 531, 700, 710, 5 },
   { 357, 702, 711, 11 },
   { 71, 705, 712, 3 },
   { 837, 703, 713, 10 },
   { 455, 705, 714, 11 },
   { 185, 707, 715, 3 },
   { 193, 708, 716, 3 },
   { 647, 707, 717, 3 },
   { 37, 712, 718, 3 },
   { 615, 709, 719, 7 },
   { 253, 712, 720, 3 },
   { 1717, 710, 721, 6 },
   { 867, 712, 722, 10 },
   { 379, 714, 723, 3 },
   { 389, 715, 724, 3 },
   { 57, 719, 725, 7 },
   { 159, 718, 726, 5 },
   { 161, 719, 727, 3 },
   { 133, 720, 728, 3 },
   { 97, 722, 729, 3 },
   { 2473, 718, 730, 3 },
   { 1603, 720, 731, 6 },
   { 33, 726, 732, 5 },
   { 67, 726, 733, 3 },
   { 213, 726, 734, 5 },
   { 759, 725, 735, 7 },
   { 955, 726, 736, 3 },
   { 165, 729, 737, 7 },
   { 1031, 727, 738, 3 },
   { 121, 732, 739, 3 },
   { 113, 733, 740, 3 },
   { 837, 731, 741, 5 },
   { 771, 732, 742, 5 },
   { 103, 736, 743, 3 },
   { 269, 735, 744, 3 },
   { 25, 740, 745, 3 },
   { 4015, 734, 746, 3 },
   { 63, 741, 747, 11 },
   { 903, 738, 748, 10 },
   { 123, 742, 749, 5 },
   { 895, 740, 750, 6 },
   { 609, 741, 751, 17 },
   { 17, 747, 752, 3 },
   { 25, 748, 753, 3 },
   { 333, 745, 754, 5 },
   { 1033, 744, 755, 3 },
   { 441, 747, 756, 11 },
   { 831, 747, 757, 7 },
   { 393, 749, 758, 10 },
   { 423, 750, 759, 13 },
   { 95, 753, 760, 3 },
   { 221, 753, 761, 3 },
   { 1119, 751, 762, 7 },
   { 505, 754, 763, 3 },
   { 141, 756, 764, 5 },
   { 331, 756, 765, 3 },
   { 555, 756, 766, 7 },
   { 373, 758, 767, 3 },
   { 1481, 757, 768, 3 },
   { 291, 760, 769, 5 },
   { 479, 761, 770, 3 },
   { 1117, 760, 771, 3 },
   { 693, 762, 772, 10 },
   { 131, 765, 773, 3 },
   { 63, 768, 774, 23 },
   { 1035, 764, 775, 11 },
   { 279, 767, 776, 5 },
   { 333, 768, 777, 11 },
   { 455, 769, 778, 6 },
   { 219, 771, 779, 7 },
   { 253, 772, 780, 3 },
   { 1159, 770, 781, 3 },
   { 757, 772, 782, 3 },
   { 981, 773, 783, 5 },
   { 43, 778, 784, 3 },
   { 321, 776, 785, 5 },
   { 9, 782, 786, 10 },
   { 345, 778, 787, 7 },
   { 1229, 777, 788, 3 },
   { 239, 781, 789, 3 },
   { 393, 781, 790, 5 },
   { 189, 783, 791, 5 },
   { 699, 782, 792, 5 },
   { 651, 783, 793, 11 },
   { 129, 786, 794, 5 },
   { 121, 788, 795, 3 },
   { 181, 788, 796, 3 },
   { 221, 789, 797, 3 },
   { 269, 789, 798, 3 },
   { 435, 790, 799, 7 },
   { 305, 791, 800, 6 },
   { 313, 792, 801, 3 },
   { 177, 794, 802, 11 },
   { 891, 793, 803, 7 },
   { 243, 796, 804, 11 },
   { 1099, 794, 805, 3 },
   { 1701, 795, 806, 41 },
   { 45, 801, 807, 13 },
   { 1173, 797, 808, 5 },
   { 989, 799, 809, 3 },
   { 727, 800, 810, 3 },
   { 711, 801, 811, 7 },
   { 335, 803, 812, 3 },
   { 2283, 801, 813, 13 },
   { 449, 805, 814, 3 },
   { 231, 807, 815, 17 },
   { 81, 809, 816, 5 },
   { 143, 809, 817, 3 },
   { 381, 809, 818, 5 },
   { 239, 811, 819, 3 },
   { 327, 811, 820, 5 },
   { 483, 812, 821, 17 },
   { 585, 812, 822, 7 },
   { 345, 814, 823, 43 },
   { 39, 818, 824, 7 },
   { 355, 816, 825, 6 },
   { 189, 818, 826, 10 },
   { 149, 819, 827, 3 },
   { 297, 819, 828, 5 },
   { 1197, 818, 829, 11 },
   { 1239, 819, 830, 5 },
   { 51, 825, 831, 5 },
   { 147, 824, 832, 5 },
   { 7, 830, 833, 3 },
   { 33, 828, 834, 13 },
   { 149, 827, 835, 3 },
   { 937, 826, 836, 3 },
   { 325, 828, 837, 3 },
   { 75, 831, 838, 19 },
   { 123, 832, 839, 13 },
   { 1365, 829, 840, 23 },
   { 569, 831, 841, 3 },
   { 253, 834, 842, 5 },
   { 1575, 832, 843, 17 },
   { 1121, 833, 844, 3 },
   { 171, 837, 845, 5 },
   { 229, 838, 846, 3 },
   { 1641, 836, 847, 5 },
   { 395, 839, 848, 3 },
   { 69, 842, 849, 5 },
   { 177, 842, 850, 13 },
   { 249, 843, 851, 11 },
   { 1359, 841, 852, 7 },
   { 233, 845, 853, 3 },
   { 595, 844, 854, 11 },
   { 267, 846, 855, 13 },
   { 357, 847, 856, 13 },
   { 741, 847, 857, 7 },
   { 1271, 847, 858, 3 },
   { 81, 852, 859, 5 },
   { 1499, 849, 860, 3 },
   { 1107, 850, 861, 11 },
   { 199, 854, 862, 3 },
   { 53, 857, 863, 3 },
   { 175, 856, 864, 3 },
   { 191, 857, 865, 3 },
   { 2755, 854, 866, 3 },
   { 453, 858, 867, 7 },
   { 195, 860, 868, 17 },
   { 741, 859, 869, 7 },
   { 1061, 859, 870, 3 },
   { 39, 865, 871, 11 },
   { 177, 864, 872, 5 },
   { 1555, 862, 873, 6 },
   { 117, 867, 874, 5 },
   { 357, 866, 875, 11 },
   { 371, 867, 876, 3 },
   { 67, 870, 877, 3 },
   { 1605, 867, 878, 7 },
   { 521, 869, 879, 3 },
   { 1155, 869, 880, 26 },
   { 1663, 870, 881, 3 },
   { 1499, 871, 882, 3 },
   { 137, 875, 883, 3 },
   { 1005, 874, 884, 11 },
   { 315, 876, 885, 19 },
   { 801, 876, 886, 10 },
   { 231, 879, 887, 17 },
   { 217, 880, 888, 3 },
   { 519, 879, 889, 10 },
   { 1391, 879, 890, 3 },
   { 285, 882, 891, 13 },
   { 637, 882, 892, 3 },
   { 849, 883, 893, 5 },
   { 757, 884, 894, 3 },
   { 989, 885, 895, 3 },
   { 147, 888, 896, 5 },
   { 941, 887, 897, 3 },
   { 681, 888, 898, 5 },
   { 641, 889, 899, 3 },
   { 223, 892, 900, 3 },
   { 99, 894, 901, 5 },
   { 831, 892, 902, 10 },
   { 135, 895, 903, 7 },
   { 15, 900, 904, 17 },
   { 141, 897, 905, 10 },
   { 381, 897, 906, 5 },
   { 499, 898, 907, 5 },
   { 1905, 897, 908, 17 },
   { 231, 901, 909, 5 },
   { 541, 900, 910, 3 },
   { 1431, 900, 911, 5 },
   { 435, 903, 912, 17 },
   { 569, 903, 913, 3 },
   { 631, 904, 914, 3 },
   { 3119, 903, 915, 3 },
   { 933, 906, 916, 5 },
   { 537, 907, 917, 10 },
   { 793, 908, 918, 3 },
   { 221, 911, 919, 3 },
   { 1431, 909, 920, 5 },
   { 1299, 910, 921, 5 },
   { 139, 914, 922, 3 },
   { 3851, 911, 923, 3 },
   { 925, 914, 924, 3 },
   { 141, 917, 925, 7 },
   { 1877, 915, 926, 3 },
   { 1251, 916, 927, 11 },
   { 375, 919, 928, 11 },
   { 149, 921, 929, 3 },
   { 135, 922, 930, 14 },
   { 765, 921, 931, 11 },
   { 431, 923, 932, 3 },
   { 1507, 922, 933, 3 },
   { 745, 924, 934, 6 },
   { 785, 925, 935, 7 },
   { 347, 927, 936, 3 },
   { 421, 928, 937, 3 },
   { 1335, 927, 938, 17 },
   { 149, 931, 939, 3 },
   { 223, 932, 940, 3 },
   { 185, 933, 941, 3 },
   { 1335, 931, 942, 23 },
   { 231, 935, 943, 13 },
   { 769, 934, 944, 3 },
   { 1477, 934, 945, 3 },
   { 1509, 935, 946, 5 },
   { 791, 937, 947, 3 },
   { 125, 941, 948, 3 },
   { 891, 939, 949, 7 },
   { 465, 941, 950, 7 },
   { 1635, 940, 951, 22 },
   { 195, 944, 952, 11 },
   { 1393, 942, 953, 3 },
   { 531, 944, 954, 5 },
   { 641, 945, 955, 3 },
   { 1899, 945, 956, 7 },
   { 969, 947, 957, 13 },
   { 1015, 948, 958, 3 },
   { 3639, 947, 959, 5 },
   { 193, 952, 960, 3 },
   { 1633, 950, 961, 3 },
   { 2527, 950, 962, 3 },
   { 2889, 951, 963, 5 },
   { 207, 956, 964, 5 },
   { 393, 956, 965, 7 },
   { 2769, 954, 966, 7 },
   { 813, 957, 967, 5 },
   { 113, 961, 968, 3 },
   { 825, 959, 969, 17 },
   { 1871, 959, 970, 3 },
   { 127, 964, 971, 3 },
   { 1205, 961, 972, 6 },
   { 505, 964, 973, 3 },
   { 129, 966, 974, 5 },
   { 1143, 964, 975, 7 },
   { 2601, 964, 976, 5 },
   { 79, 970, 977, 3 },
   { 101, 971, 978, 3 },
   { 611, 969, 979, 3 },
   { 1323, 969, 980, 17 },
   { 1225, 970, 981, 3 },
   { 495, 973, 982, 23 },
   { 423, 974, 983, 5 },
   { 567, 974, 984, 13 },
   { 411, 976, 985, 5 },
   { 1395, 975, 986, 13 },
   { 1143, 976, 987, 21 },
   { 407, 979, 988, 3 },
   { 1407, 978, 989, 19 },
   { 441, 981, 990, 5 },
   { 75, 984, 991, 11 },
   { 1425, 981, 992, 7 },
   { 233, 985, 993, 3 },
   { 901, 984, 994, 3 },
   { 939, 985, 995, 11 },
   { 231, 988, 996, 5 },
   { 453, 988, 997, 11 },
   { 1629, 987, 998, 5 },
   { 2289, 987, 999, 5 },
   { 95, 993, 1000, 3 },
   { 501, 992, 1001, 5 },
   { 1461, 991, 1002, 11 },
   { 439, 994, 1003, 3 },
   { 13, 1000, 1004, 6 },
   { 1329, 994, 1005, 5 },
   { 3073, 994, 1006, 3 },
   { 933, 997, 1007, 7 },
   { 347, 999, 1008, 3 },
   { 153, 1001, 1009, 11 },
   { 363, 1001, 1010, 13 },
   { 4323, 998, 1011, 7 },
   { 429, 1003, 1012, 5 },
   { 725, 1003, 1013, 3 },
   { 567, 1004, 1014, 5 },
   { 171, 1007, 1015, 7 },
   { 525, 1006, 1016, 11 },
   { 939, 1007, 1017, 5 },
   { 393, 1009, 1018, 5 },
   { 729, 1009, 1019, 7 },
   { 1545, 1009, 1020, 29 },
   { 165, 1013, 1021, 7 },
   { 3025, 1010, 1022, 3 },
   { 273, 1014, 1023, 10 },
   { 1331, 1013, 1024, 3 },
   { 75, 1018, 1025, 11 },
   { 715, 1016, 1026, 3 },
   { 93, 1020, 1027, 7 },
   { 225, 1020, 1028, 11 },
   { 755, 1019, 1029, 3 },
   { 1191, 1019, 1030, 11 },
   { 207, 1023, 1031, 5 },
   { 2403, 1020, 1032, 7 },
   { 725, 1023, 1033, 3 },
   { 413, 1025, 1034, 3 },
   { 611, 1025, 1035, 3 },
   { 763, 1026, 1036, 3 },
   { 277, 1028, 1037, 3 },
   { 225, 1030, 1038, 7 },
   { 1011, 1029, 1039, 5 },
   { 177, 1032, 1040, 7 },
   { 435, 1032, 1041, 13 },
   { 1775, 1031, 1042, 3 },
   { 1225, 1032, 1043, 3 },
   { 1133, 1033, 1044, 3 },
   { 471, 1036, 1045, 5 },
   { 95, 1039, 1046, 3 },
   { 1047, 1036, 1047, 5 },
   { 255, 1040, 1048, 7 },
   { 315, 1040, 1049, 11 },
   { 345, 1041, 1050, 7 },
   { 653, 1041, 1051, 3 },
   { 113, 1045, 1052, 3 },
   { 195, 1045, 1053, 7 },
   { 291, 1045, 1054, 5 },
   { 149, 1047, 1055, 3 },
   { 1941, 1045, 1056, 5 },
   { 735, 1047, 1057, 23 },
   { 29, 1053, 1058, 3 },
   { 615, 1049, 1059, 11 },
   { 193, 1052, 1060, 3 },
   { 75, 1054, 1061, 11 },
   { 3153, 1050, 1062, 5 },
   { 39, 1057, 1063, 17 },
   { 381, 1055, 1064, 7 },
   { 427, 1056, 1065, 3 },
   { 1725, 1055, 1066, 7 },
   { 1731, 1056, 1067, 5 },
   { 1155, 1057, 1068, 29 },
   { 301, 1060, 1069, 3 },
   { 249, 1062, 1070, 5 },
   { 367, 1062, 1071, 3 },
   { 673, 1062, 1072, 3 },
   { 4503, 1060, 1073, 34 },
   { 453, 1065, 1074, 7 },
   { 711, 1065, 1075, 5 },
   { 1003, 1066, 1076, 3 },
   { 2061, 1065, 1077, 5 },
   { 193, 1070, 1078, 3 },
   { 129, 1071, 1079, 5 },
   { 2121, 1068, 1080, 10 },
   { 27, 1076, 1081, 5 },
   { 43, 1076, 1082, 3 },
   { 319, 1074, 1083, 3 },
   { 335, 1075, 1084, 3 },
   { 2159, 1073, 1085, 3 },
   { 675, 1076, 1086, 7 },
   { 225, 1079, 1087, 17 },
   { 1863, 1077, 1088, 5 },
   { 427, 1080, 1089, 3 },
   { 1047, 1079, 1090, 5 },
   { 59, 1085, 1091, 3 },
   { 2245, 1080, 1092, 3 },
   { 1633, 1082, 1093, 3 },
   { 465, 1085, 1094, 7 },
   { 27, 1090, 1095, 7 },
   { 335, 1087, 1096, 17 },
   { 225, 1089, 1097, 13 },
   { 1017, 1088, 1098, 10 },
   { 1851, 1088, 1099, 5 },
   { 133, 1092, 1100, 3 },
   { 1717, 1090, 1101, 3 },
   { 751, 1092, 1102, 3 },
   { 2085, 1091, 1103, 11 },
   { 261, 1095, 1104, 7 },
   { 127, 1098, 1105, 3 },
   { 1319, 1095, 1106, 3 },
   { 273, 1098, 1107, 5 },
   { 1989, 1097, 1108, 7 },
   { 1597, 1098, 1109, 3 },
   { 101, 1103, 1110, 3 },
   { 581, 1101, 1111, 5 },
   { 1361, 1101, 1112, 3 },
   { 487, 1104, 1113, 3 },
   { 1425, 1103, 1114, 26 },
   { 295, 1106, 1115, 3 },
   { 471, 1107, 1116, 7 },
   { 93, 1110, 1117, 10 },
   { 741, 1108, 1118, 7 },
   { 2237, 1107, 1119, 3 },
   { 225, 1112, 1120, 13 },
   { 267, 1112, 1121, 7 },
   { 119, 1115, 1122, 3 },
   { 349, 1114, 1123, 3 },
   { 365, 1115, 1124, 3 },
   { 611, 1115, 1125, 3 },
   { 931, 1116, 1126, 3 },
   { 1765, 1116, 1127, 6 },
   { 769, 1118, 1128, 3 },
   { 621, 1119, 1129, 7 },
   { 1757, 1119, 1130, 3 },
   { 439, 1122, 1131, 3 },
   { 151, 1124, 1132, 3 },
   { 515, 1123, 1133, 3 },
   { 1217, 1123, 1134, 3 },
   { 959, 1125, 1135, 3 },
   { 275, 1127, 1136, 3 },
   { 1089, 1126, 1137, 5 },
   { 335, 1129, 1138, 3 },
   { 593, 1129, 1139, 3 },
   { 375, 1131, 1140, 13 },
   { 1527, 1130, 1141, 7 },
   { 651, 1132, 1142, 5 },
   { 1035, 1132, 1143, 7 },
   { 2841, 1132, 1144, 5 },
   { 255, 1137, 1145, 13 },
   { 133, 1138, 1146, 3 },
   { 1407, 1136, 1147, 5 },
   { 753, 1138, 1148, 10 },
   { 423, 1140, 1149, 11 },
   { 393, 1141, 1150, 5 },
   { 279, 1142, 1151, 5 },
   { 1055, 1141, 1152, 3 },
   { 427, 1144, 1153, 5 },
   { 205, 1146, 1154, 3 },
   { 67, 1148, 1155, 3 },
   { 63, 1150, 1156, 10 },
   { 621, 1147, 1157, 13 },
   { 261, 1149, 1158, 5 },
   { 1365, 1148, 1159, 23 },
   { 419, 1151, 1160, 3 },
   { 1377, 1150, 1161, 38 },
   { 957, 1152, 1162, 10 },
   { 385, 1154, 1163, 3 },
   { 297, 1155, 1164, 13 },
   { 647, 1155, 1165, 3 },
   { 1961, 1155, 1166, 3 },
   { 1035, 1156, 1167, 7 },
   { 275, 1159, 1168, 6 },
   { 215, 1161, 1169, 3 },
   { 303, 1161, 1170, 5 },
   { 2091, 1159, 1171, 11 },
   { 649, 1162, 1172, 3 },
   { 355, 1164, 1173, 3 },
   { 393, 1165, 1174, 5 },
   { 999, 1165, 1175, 19 },
   { 299, 1167, 1176, 3 },
   { 689, 1167, 1177, 3 },
   { 279, 1169, 1178, 13 },
   { 1297, 1168, 1179, 3 },
   { 29, 1175, 1180, 3 },
   { 1389, 1170, 1181, 15 },
   { 667, 1172, 1182, 3 },
   { 197, 1175, 1183, 3 },
   { 933, 1174, 1184, 5 },
   { 239, 1177, 1185, 3 },
   { 955, 1176, 1186, 6 },
   { 1071, 1176, 1187, 5 },
   { 299, 1179, 1188, 3 },
   { 987, 1179, 1189, 5 },
   { 365, 1181, 1190, 3 },
   { 603, 1181, 1191, 5 },
   { 537, 1182, 1192, 14 },
   { 567, 1183, 1193, 13 },
   { 555, 1184, 1194, 47 },
   { 185, 1187, 1195, 6 },
   { 449, 1187, 1196, 3 },
   { 225, 1189, 1197, 19 },
   { 335, 1189, 1198, 3 },
   { 1137, 1188, 1199, 5 },
   { 299, 1191, 1200, 3 },
   { 2315, 1189, 1201, 3 },
   { 3213, 1190, 1202, 10 },
   { 659, 1193, 1203, 3 },
   { 253, 1196, 1204, 3 },
   { 977, 1195, 1205, 3 },
   { 309, 1197, 1206, 11 },
   { 813, 1197, 1207, 5 },
   { 49, 1202, 1208, 3 },
   { 135, 1201, 1209, 7 },
   { 897, 1200, 1210, 11 },
   { 1717, 1200, 1211, 3 },
   { 125, 1205, 1212, 3 },
   { 1737, 1202, 1213, 7 },
   { 503, 1205, 1214, 3 },
   { 1197, 1204, 1215, 10 },
   { 663, 1206, 1216, 5 },
   { 1377, 1206, 1217, 7 },
   { 1157, 1207, 1218, 3 },
   { 3345, 1207, 1219, 13 },
   { 317, 1211, 1220, 3 },
   { 809, 1211, 1221, 3 },
   { 3535, 1210, 1222, 15 },
   { 505, 1214, 1223, 6 },
   { 787, 1214, 1224, 3 },
   { 255, 1217, 1225, 31 },
   { 1391, 1215, 1226, 3 },
   { 1341, 1216, 1227, 5 },
   { 649, 1218, 1228, 3 },
   { 403, 1220, 1229, 3 },
   { 303, 1221, 1230, 5 },
   { 659, 1221, 1231, 3 },
   { 663, 1222, 1232, 11 },
   { 1705, 1222, 1233, 3 },
   { 341, 1225, 1234, 3 },
   { 2909, 1223, 1235, 3 },
   { 339, 1227, 1236, 5 },
   { 929, 1227, 1237, 3 },
   { 861, 1228, 1238, 5 },
   { 1245, 1228, 1239, 7 },
   { 359, 1231, 1240, 3 },
   { 659, 1231, 1241, 3 },
   { 861, 1232, 1242, 10 },
   { 209, 1235, 1243, 5 },
   { 855, 1234, 1244, 14 },
   { 153, 1237, 1245, 5 },
   { 37, 1240, 1246, 3 },
   { 951, 1237, 1247, 5 },
   { 223, 1240, 1248, 3 },
   { 457, 1240, 1249, 3 },
   { 1649, 1239, 1250, 3 },
   { 19, 1246, 1251, 3 },
   { 603, 1242, 1252, 5 },
   { 445, 1244, 1253, 3 },
   { 465, 1245, 1254, 34 },
   { 533, 1245, 1255, 3 },
   { 1103, 1245, 1256, 3 },
   { 191, 1249, 1257, 3 },
   { 1121, 1247, 1258, 3 },
   { 465, 1250, 1259, 14 },
   { 693, 1250, 1260, 5 },
   { 155, 1253, 1261, 3 },
   { 449, 1253, 1262, 3 },
   { 903, 1253, 1263, 5 },
   { 687, 1254, 1264, 23 },
   { 659, 1255, 1265, 3 },
   { 1565, 1255, 1266, 3 },
   { 701, 1257, 1267, 3 },
   { 287, 1259, 1268, 3 },
   { 1297, 1258, 1269, 3 },
   { 771, 1260, 1270, 5 },
   { 385, 1262, 1271, 3 },
   { 729, 1262, 1272, 7 },
   { 231, 1265, 1273, 5 },
   { 1179, 1263, 1274, 5 },
   { 87, 1268, 1275, 5 },
   { 2491, 1264, 1276, 3 },
   { 1435, 1266, 1277, 6 },
   { 195, 1270, 1278, 7 },
   { 429, 1270, 1279, 5 },
   { 595, 1270, 1280, 6 },
   { 515, 1271, 1281, 3 },
   { 281, 1273, 1282, 3 },
   { 297, 1274, 1283, 7 },
   { 339, 1275, 1284, 5 },
   { 25, 1280, 1285, 3 },
   { 125, 1279, 1286, 3 },
   { 1233, 1276, 1287, 7 },
   { 595, 1278, 1288, 3 },
   { 1065, 1278, 1289, 11 },
   { 807, 1280, 1290, 5 },
   { 1051, 1280, 1291, 3 },
   { 2475, 1280, 1292, 7 },
   { 2621, 1281, 1293, 3 },
   { 471, 1285, 1294, 7 },
   { 207, 1287, 1295, 5 },
   { 63, 1290, 1296, 5 },
   { 183, 1289, 1297, 7 },
   { 1209, 1287, 1298, 5 },
   { 611, 1289, 1299, 3 },
   { 261, 1291, 1300, 11 },
   { 551, 1291, 1301, 3 },
   { 263, 1293, 1302, 3 },
   { 711, 1293, 1303, 5 },
   { 859, 1294, 1304, 3 },
   { 115, 1298, 1305, 3 },
   { 273, 1297, 1306, 5 },
   { 85, 1300, 1307, 3 },
   { 639, 1298, 1308, 5 },
   { 9, 1305, 1309, 7 },
   { 199, 1302, 1310, 3 },
   { 345, 1302, 1311, 7 },
   { 619, 1302, 1312, 3 },
   { 331, 1304, 1313, 3 },
   { 841, 1304, 1314, 3 },
   { 1815, 1304, 1315, 17 },
   { 1599, 1305, 1316, 17 },
   { 243, 1309, 1317, 10 },
   { 57, 1312, 1318, 5 },
   { 831, 1309, 1319, 5 },
   { 1493, 1309, 1320, 3 },
   { 1833, 1310, 1321, 5 },
   { 315, 1313, 1322, 11 },
   { 239, 1315, 1323, 3 },
   { 65, 1317, 1324, 6 },
   { 2561, 1313, 1325, 3 },
   { 2703, 1314, 1326, 5 },
   { 3819, 1315, 1327, 5 },
   { 261, 1319, 1328, 13 },
   { 233, 1321, 1329, 3 },
   { 877, 1320, 1330, 3 },
   { 779, 1321, 1331, 3 },
   { 1065, 1321, 1332, 14 },
   { 25, 1328, 1333, 3 },
   { 339, 1325, 1334, 7 },
   { 327, 1326, 1335, 7 },
   { 663, 1326, 1336, 5 },
   { 79, 1330, 1337, 3 },
   { 1031, 1327, 1338, 3 },
   { 635, 1329, 1339, 3 },
   { 975, 1330, 1340, 11 },
   { 1779, 1330, 1341, 10 },
   { 1089, 1331, 1342, 10 },
   { 1761, 1332, 1343, 5 },
   { 1041, 1333, 1344, 10 },
   { 185, 1337, 1345, 3 },
   { 1311, 1335, 1346, 13 },
   { 325, 1338, 1347, 3 },
   { 321, 1339, 1348, 7 },
   { 447, 1340, 1349, 5 },
   { 1605, 1339, 1350, 7 },
   { 1831, 1340, 1351, 3 },
   { 269, 1343, 1352, 3 },
   { 1087, 1342, 1353, 3 },
   { 1271, 1343, 1354, 3 },
   { 593, 1345, 1355, 3 },
   { 201, 1348, 1356, 5 },
   { 2225, 1345, 1357, 3 },
   { 3607, 1346, 1358, 3 },
   { 221, 1351, 1359, 3 },
   { 281, 1351, 1360, 3 },
   { 651, 1351, 1361, 17 },
   { 715, 1352, 1362, 6 },
   { 1407, 1352, 1363, 5 },
   { 1211, 1353, 1364, 3 },
   { 345, 1356, 1365, 7 },
   { 745, 1356, 1366, 3 },
   { 533, 1357, 1367, 3 },
   { 315, 1359, 1368, 17 },
   { 3441, 1357, 1369, 5 },
   { 861, 1360, 1370, 5 },
   { 277, 1362, 1371, 3 },
   { 1749, 1361, 1372, 31 },
   { 67, 1366, 1373, 3 },
   { 145, 1366, 1374, 3 },
   { 2519, 1363, 1375, 5 },
   { 1109, 1365, 1376, 3 },
   { 1285, 1366, 1377, 3 },
   { 249, 1370, 1378, 17 },
   { 363, 1370, 1379, 5 },
   { 45, 1374, 1380, 19 },
   { 2193, 1369, 1381, 7 },
   { 645, 1372, 1382, 14 },
   { 729, 1373, 1383, 7 },
   { 477, 1375, 1384, 5 },
   { 1143, 1374, 1385, 10 },
   { 741, 1376, 1386, 10 },
   { 701, 1377, 1387, 3 },
   { 201, 1380, 1388, 5 },
   { 989, 1379, 1389, 3 },
   { 273, 1381, 1390, 10 },
   { 81, 1384, 1391, 11 },
   { 765, 1382, 1392, 13 },
   { 4061, 1381, 1393, 3 },
   { 429, 1385, 1394, 23 },
   { 1273, 1384, 1395, 3 },
   { 1071, 1385, 1396, 5 },
   { 463, 1388, 1397, 3 },
   { 1611, 1387, 1398, 7 },
   { 1047, 1388, 1399, 7 },
   { 497, 1391, 1400, 3 },
   { 511, 1392, 1401, 3 },
   { 843, 1392, 1402, 11 },
   { 729, 1393, 1403, 7 },
   { 799, 1394, 1404, 6 },
   { 57, 1399, 1405, 5 },
   { 345, 1397, 1406, 11 },
   { 507, 1398, 1407, 29 },
   { 907, 1398, 1408, 3 },
   { 2625, 1397, 1409, 13 },
   { 135, 1402, 1410, 14 },
   { 1351, 1400, 1411, 3 },
   { 975, 1402, 1412, 11 },
   { 539, 1403, 1413, 3 },
   { 363, 1405, 1414, 5 },
   { 9, 1411, 1415, 5 },
   { 211, 1408, 1416, 3 },
   { 191, 1409, 1417, 3 },
   { 125, 1411, 1418, 3 },
   { 399, 1410, 1419, 10 },
   { 2091, 1408, 1420, 5 },
   { 2313, 1409, 1421, 5 },
   { 1005, 1412, 1422, 7 },
   { 117, 1416, 1423, 5 },
   { 465, 1415, 1424, 13 },
   { 165, 1417, 1425, 13 },
   { 33, 1420, 1426, 31 },
   { 127, 1420, 1427, 3 },
   { 2045, 1417, 1428, 3 },
   { 35, 1423, 1429, 3 },
   { 751, 1420, 1430, 3 },
   { 357, 1422, 1431, 11 },
   { 1091, 1421, 1432, 3 },
   { 1503, 1422, 1433, 5 },
   { 431, 1425, 1434, 3 },
   { 1683, 1424, 1435, 14 },
   { 613, 1426, 1436, 3 },
   { 1057, 1426, 1437, 3 },
   { 583, 1428, 1438, 3 },
   { 1183, 1428, 1439, 6 },
   { 231, 1432, 1440, 13 },
   { 941, 1431, 1441, 3 },
   { 1781, 1431, 1442, 3 },
   { 801, 1433, 1443, 5 },
   { 1673, 1433, 1444, 3 },
   { 1107, 1434, 1445, 19 },
   { 793, 1436, 1446, 3 },
   { 63, 1441, 1447, 10 },
   { 381, 1439, 1448, 11 },
   { 35, 1443, 1449, 3 },
   { 393, 1441, 1450, 5 },
   { 447, 1442, 1451, 11 },
   { 1203, 1441, 1452, 7 },
   { 189, 1445, 1453, 11 },
   { 951, 1444, 1454, 23 },
   { 379, 1446, 1455, 3 },
   { 747, 1446, 1456, 7 },
   { 69, 1450, 1457, 10 },
   { 459, 1449, 1458, 13 },
   { 255, 1451, 1459, 7 },
   { 1865, 1449, 1460, 3 },
   { 161, 1453, 1461, 6 },
   { 207, 1454, 1462, 7 },
   { 849, 1453, 1463, 7 },
   { 223, 1456, 1464, 3 },
   { 1395, 1454, 1465, 11 },
   { 1271, 1455, 1466, 3 },
   { 1287, 1456, 1467, 15 },
   { 157, 1460, 1468, 3 },
   { 221, 1461, 1469, 3 },
   { 135, 1462, 1470, 11 },
   { 1057, 1460, 1471, 3 },
   { 3121, 1460, 1472, 3 },
   { 2703, 1461, 1473, 5 },
   { 345, 1465, 1474, 7 },
   { 1503, 1464, 1475, 7 },
   { 693, 1466, 1476, 5 },
   { 2105, 1465, 1477, 3 },
   { 169, 1470, 1478, 3 },
   { 585, 1469, 1479, 7 },
   { 847, 1470, 1480, 3 },
   { 3021, 1469, 1481, 5 },
   { 431, 1473, 1482, 3 },
   { 605, 1473, 1483, 3 },
   { 1505, 1473, 1484, 3 },
   { 93, 1478, 1485, 10 },
   { 169, 1478, 1486, 5 },
   { 819, 1477, 1487, 23 },
   { 583, 1478, 1488, 3 },
   { 47, 1483, 1489, 3 },
   { 229, 1482, 1490, 3 },
   { 51, 1485, 1491, 5 },
   { 429, 1483, 1492, 5 },
   { 501, 1484, 1493, 5 },
   { 741, 1484, 1494, 11 },
   { 611, 1485, 1495, 3 },
   { 1109, 1485, 1496, 3 },
   { 2565, 1485, 1497, 11 },
   { 9, 1494, 1498, 5 },
   { 1125, 1488, 1499, 13 },
   { 2607, 1488, 1500, 10 },
   { 2805, 1489, 1501, 13 },
   { 3543, 1490, 1502, 7 },
   { 3581, 1491, 1503, 3 },
   { 2125, 1492, 1504, 3 },
   { 827, 1495, 1505, 3 },
   { 1397, 1495, 1506, 3 },
   { 1593, 1496, 1507, 7 },
   { 655, 1498, 1508, 3 },
   { 569, 1499, 1509, 5 },
   { 1409, 1499, 1510, 3 },
   { 1171, 1500, 1511, 3 },
   { 753, 1502, 1512, 5 },
   { 1833, 1502, 1513, 5 },
   { 459, 1505, 1514, 7 },
   { 1957, 1504, 1515, 3 },
   { 253, 1508, 1516, 3 },
   { 1569, 1506, 1517, 5 },
   { 675, 1508, 1518, 7 },
   { 179, 1511, 1519, 3 },
   { 817, 1510, 1520, 6 },
   { 659, 1511, 1521, 3 },
   { 15, 1518, 1522, 11 },
   { 499, 1514, 1523, 3 },
   { 329, 1515, 1524, 3 },
   { 855, 1515, 1525, 17 },
   { 1215, 1515, 1526, 7 },
   { 759, 1517, 1527, 7 },
   { 429, 1519, 1528, 5 },
   { 879, 1519, 1529, 5 },
   { 2203, 1518, 1530, 3 },
   { 135, 1523, 1531, 23 },
   { 2503, 1520, 1532, 3 },
   { 1159, 1522, 1533, 3 },
   { 501, 1525, 1534, 5 },
   { 641, 1525, 1535, 3 },
   { 193, 1528, 1536, 3 },
   { 21, 1532, 1537, 5 },
   { 1547, 1527, 1538, 5 },
   { 879, 1529, 1539, 7 },
   { 165, 1532, 1540, 17 },
   { 1039, 1530, 1541, 3 },
   { 1449, 1531, 1542, 11 },
   { 975, 1533, 1543, 7 },
   { 89, 1537, 1544, 3 },
   { 1549, 1534, 1545, 3 },
   { 411, 1537, 1546, 5 },
   { 3135, 1535, 1547, 26 },
   { 113, 1541, 1548, 3 },
   { 415, 1540, 1549, 6 },
   { 293, 1541, 1550, 3 },
   { 581, 1541, 1551, 3 },
   { 537, 1542, 1552, 7 },
   { 795, 1543, 1553, 41 },
   { 1971, 1543, 1554, 11 },
   { 3869, 1543, 1555, 3 },
   { 979, 1546, 1556, 3 },
   { 759, 1547, 1557, 5 },
   { 345, 1549, 1558, 7 },
   { 1687, 1548, 1559, 3 },
   { 145, 1552, 1560, 3 },
   { 3641, 1549, 1561, 3 },
   { 291, 1553, 1562, 11 },
   { 969, 1553, 1563, 14 },
   { 347, 1555, 1564, 3 },
   { 921, 1555, 1565, 19 },
   { 1845, 1555, 1566, 19 },
   { 1257, 1556, 1567, 5 },
   { 497, 1559, 1568, 3 },
   { 1467, 1558, 1569, 13 },
   { 1589, 1559, 1570, 3 },
   { 469, 1562, 1571, 3 },
   { 207, 1564, 1572, 5 },
   { 153, 1565, 1573, 10 },
   { 491, 1565, 1574, 3 },
   { 1185, 1564, 1575, 7 },
   { 429, 1567, 1576, 5 },
   { 345, 1568, 1577, 17 },
   { 871, 1568, 1578, 3 },
   { 1423, 1568, 1579, 3 },
   { 799, 1570, 1580, 3 },
   { 109, 1574, 1581, 3 },
   { 303, 1573, 1582, 7 },
   { 629, 1573, 1583, 3 },
   { 615, 1574, 1584, 11 },
   { 255, 1577, 1585, 7 },
   { 513, 1576, 1586, 13 },
   { 735, 1577, 1587, 29 },
   { 411, 1579, 1588, 19 },
   { 261, 1580, 1589, 5 },
   { 1715, 1579, 1590, 6 },
   { 1623, 1580, 1591, 11 },
   { 371, 1583, 1592, 3 },
   { 2075, 1581, 1593, 3 },
   { 2275, 1582, 1594, 3 },
   { 855, 1585, 1595, 14 },
   { 133, 1588, 1596, 6 },
   { 255, 1589, 1597, 21 },
   { 189, 1590, 1598, 5 },
   { 1383, 1588, 1599, 17 },
   { 759, 1590, 1600, 5 },
   { 1675, 1590, 1601, 3 },
   { 1077, 1591, 1602, 5 },
   { 3771, 1591, 1603, 19 },
   { 3457, 1592, 1604, 3 },
   { 1273, 1594, 1605, 3 },
   { 263, 1597, 1606, 3 },
   { 149, 1599, 1607, 3 },
   { 39, 1602, 1608, 7 },
   { 521, 1599, 1609, 3 },
   { 733, 1600, 1610, 3 },
   { 2115, 1599, 1611, 11 },
   { 577, 1602, 1612, 3 },
   { 1575, 1602, 1613, 29 },
   { 189, 1606, 1614, 15 },
   { 543, 1605, 1615, 5 },
   { 371, 1607, 1616, 3 },
   { 737, 1607, 1617, 3 },
   { 21, 1613, 1618, 5 },
   { 135, 1611, 1619, 7 },
   { 243, 1612, 1620, 23 },
   { 435, 1612, 1621, 7 },
   { 75, 1615, 1622, 23 },
   { 819, 1613, 1623, 11 },
   { 99, 1617, 1624, 13 },
   { 581, 1615, 1625, 6 },
   { 1003, 1616, 1626, 3 },
   { 417, 1618, 1627, 17 },
   { 501, 1619, 1628, 7 },
   { 659, 1619, 1629, 3 },
   { 4929, 1617, 1630, 19 },
   { 215, 1623, 1631, 3 },
   { 709, 1622, 1632, 3 },
   { 1555, 1622, 1633, 6 },
   { 1055, 1623, 1634, 6 },
   { 513, 1625, 1635, 5 },
   { 33, 1630, 1636, 10 },
   { 599, 1627, 1637, 3 },
   { 65, 1631, 1638, 3 },
   { 1695, 1628, 1639, 7 },
   { 201, 1632, 1640, 5 },
   { 2391, 1629, 1641, 5 },
   { 757, 1632, 1642, 3 },
   { 711, 1633, 1643, 5 },
   { 3447, 1632, 1644, 10 },
   { 25, 1640, 1645, 3 },
   { 77, 1639, 1646, 5 },
   { 2111, 1635, 1647, 3 },
   { 1773, 1637, 1648, 5 },
   { 1293, 1638, 1649, 5 },
   { 163, 1642, 1650, 3 },
   { 5583, 1638, 1651, 10 },
   { 1731, 1641, 1652, 5 },
   { 93, 1646, 1653, 5 },
   { 1355, 1643, 1654, 3 },
   { 1177, 1644, 1655, 3 },
   { 1485, 1645, 1656, 21 },
   { 719, 1647, 1657, 3 },
   { 1941, 1647, 1658, 7 },
   { 1345, 1648, 1659, 3 },
   { 133, 1652, 1660, 6 },
   { 1107, 1650, 1661, 11 },
   { 483, 1653, 1662, 10 },
   { 2385, 1651, 1663, 13 },
   { 1605, 1653, 1664, 13 },
   { 711, 1655, 1665, 14 },
   { 2217, 1654, 1666, 13 },
   { 1593, 1656, 1667, 7 },
   { 2637, 1656, 1668, 7 },
   { 1183, 1658, 1669, 3 },
   { 1437, 1659, 1670, 5 },
   { 53, 1665, 1671, 3 },
   { 865, 1662, 1672, 3 },
   { 1425, 1662, 1673, 7 },
   { 303, 1665, 1674, 5 },
   { 849, 1665, 1675, 11 },
   { 431, 1667, 1676, 3 },
   { 355, 1668, 1677, 3 },
   { 2001, 1667, 1678, 13 },
   { 6393, 1666, 1679, 7 },
   { 211, 1672, 1680, 3 },
   { 1437, 1670, 1681, 11 },
   { 3093, 1670, 1682, 15 },
   { 1255, 1672, 1683, 3 },
   { 123, 1677, 1684, 5 },
   { 2243, 1673, 1685, 3 },
   { 661, 1676, 1686, 3 },
   { 669, 1677, 1687, 7 },
   { 793, 1678, 1688, 3 },
   { 675, 1679, 1689, 13 },
   { 921, 1680, 1690, 5 },
   { 645, 1681, 1691, 14 },
   { 2565, 1680, 1692, 13 },
   { 5463, 1680, 1693, 11 },
   { 1215, 1683, 1694, 7 },
   { 783, 1685, 1695, 10 },
   { 555, 1686, 1696, 7 },
   { 4923, 1684, 1697, 7 },
   { 299, 1689, 1698, 3 },
   { 67, 1692, 1699, 3 },
   { 365, 1691, 1700, 3 },
   { 1713, 1690, 1701, 10 },
   { 945, 1692, 1702, 11 },
   { 641, 1693, 1703, 3 },
   { 837, 1694, 1704, 7 },
};

// $dissect$ support.txt
const ring_data* _CL_CALL dkss_find_pc(const unsigned min_prime_bits) {
   for (index i=0; i<NBEL(rings); ++i) {
      const ring_data& r = rings[i];
      if (r.prime_bit_length > min_prime_bits) {
         return &rings[i-1];
      }
   }
   classertm(0, "no prime for that size!");
   return nullptr;
}

}  // namespace bignum
